﻿var emailTemplates = {
    datatable: null,
    changeCategoryItems: null,
    refreshDataTable: function () {
        emailTemplates.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-templatesTable").a4datatable({
            height: "full",
            ajaxAction: a4.getAction("GetTemplates", "EmailTemplates", "Library"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Class": "id" },
                { "Name": "Name", "Title": resources.Name, "Data": "Name", "HideInSelector": true },
                { "Name": "Subject", "Title": resources.Subject, "Data": "Subject" },
                { "Name": "CreatedOn", "Title": resources.CreatedOn, "Data": "CreatedOn" },
                { "Name": "LastModifiedOn", "Title": resources.LastModifiedOn, "Data": "LastModifiedOn" }
            ],
            localizableTexts: { "Search": resources.SearchEmailTemplates },
            defaultSorting: { Column: "Id", Ascending: false },
            stateKey: "EmailTemplates",
            toolBarItems: emailTemplates.getToolBarItems(),
            contextMenuItems: emailTemplates.getContextMenuItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                }

                switch (action) {
                    case "delete":
                        emailTemplates.deleteItems(ids);
                        break;
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "edit":
                        emailTemplates.editItem(row.Id);
                        break;
                    case "copy":
                        emailTemplates.copyItem(row.Id);
                        break;
                    case "delete":
                        emailTemplates.deleteItems(row.Id);
                        break;
                }
            }
        });
    },
    deleteItems: function (items) {

        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteTemplateResources, function () {
            a4.callServerMethod(a4.getAction("DeleteTemplates", "EmailTemplates", "Library"), { templateIds: items },
            function (result) {
                emailTemplates.refreshDataTable();
            });
        }, 250, 500, true, { "count": itemsCount });
    },
    editItem: function (itemId) {
        modalDialog.showWindow(a4.getAction("TemplateEditor", "EmailTemplates", "Library", { templateId: itemId }), 730, 1100);
    },
    copyItem: function (itemId) {
        modalDialog.showWindow(a4.getAction("CopyEmailTemplate", "EmailTemplates", "Library", { sourceTemplateId: itemId }), 730, 1100);
    },
    bindEvents: function () {
        $(".h-newTemplate").on("click", function () {
            modalDialog.showWindow(a4.getAction("TemplateEditor", "EmailTemplates", "Library"), 630, 1100);
        });
    },
    getContextMenuItems: function () {
        if (canModify) {
            return [{ "Action": "edit", "Label": resources.Edit },
                    { "Action": "copy", "Label": resources.Copy },
                    { "Action": "delete", "Label": resources.Delete }];
        } else return [];
    },
    getToolBarItems: function () {
        if (canModify) return [{ "Action": "delete", "Label": resources.Delete }];
        else return [];
    }
}

$(document).ready(function () {
    emailTemplates.initializeDataTable();
    emailTemplates.bindEvents();
});